//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define MAX_NODES 1000
#define MAX_EDGES 10000

typedef struct {
    int id;
    char name[32];
} Node;

typedef struct {
    int src;
    int dest;
    int weight;
} Edge;

int num_nodes = 0;
Node nodes[MAX_NODES];
int num_edges = 0;
Edge edges[MAX_EDGES];

void add_node(int id, char* name) {
    nodes[num_nodes].id = id;
    strcpy(nodes[num_nodes].name, name);
    num_nodes++;
}

void add_edge(int src, int dest, int weight) {
    edges[num_edges].src = src;
    edges[num_edges].dest = dest;
    edges[num_edges].weight = weight;
    num_edges++;
}

int main() {
    // Create nodes
    add_node(0, "A");
    add_node(1, "B");
    add_node(2, "C");
    add_node(3, "D");

    // Connect nodes
    add_edge(0, 1, 10);
    add_edge(1, 2, 5);
    add_edge(2, 3, 15);

    // Print nodes and edges
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d: %s\n", nodes[i].id, nodes[i].name);
    }

    printf("\nEdges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("(%d, %d, %d)\n", edges[i].src, edges[i].dest, edges[i].weight);
    }

    return 0;
}