//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>

#define MAX_LIGHTS 10
#define LIGHT_ON 1
#define LIGHT_OFF 0

// Define the light status structure
typedef struct {
    int status;
    char *name;
} light_t;

// Define the main function
int main() {

    // Initialize the light status array
    light_t lights[MAX_LIGHTS];

    // Initialize the light status array
    for (int i = 0; i < MAX_LIGHTS; i++) {
        lights[i].status = LIGHT_OFF;
        lights[i].name = NULL;
    }

    // Add some lights
    lights[0].status = LIGHT_ON;
    lights[0].name = "Living Room";

    lights[1].status = LIGHT_ON;
    lights[1].name = "Kitchen";

    lights[2].status = LIGHT_OFF;
    lights[2].name = "Bedroom";

    // Print the current light status
    printf("Current Light Status:\n");
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].name!= NULL) {
            printf("%s: %s\n", lights[i].name, (lights[i].status == LIGHT_ON)? "On" : "Off");
        }
    }

    // Turn off all lights
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].name!= NULL) {
            lights[i].status = LIGHT_OFF;
        }
    }

    // Print the updated light status
    printf("\nUpdated Light Status:\n");
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].name!= NULL) {
            printf("%s: %s\n", lights[i].name, (lights[i].status == LIGHT_ON)? "On" : "Off");
        }
    }

    return 0;
}