//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: distributed
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "math.h"
#include "pthread.h"

#define LEFT_MOTOR 1
#define RIGHT_MOTOR 2
#define MAX_MOTOR_SPEED 100

typedef struct {
    int motor;
    float speed;
} MotorCommand;

typedef struct {
    MotorCommand left;
    MotorCommand right;
} RobotCommand;

void* motor_control_thread(void* arg) {
    MotorCommand* command = (MotorCommand*)arg;

    // Set the motor speed
    if (command->motor == LEFT_MOTOR) {
        // Set left motor speed
        printf("Setting left motor speed to %f\n", command->speed);
    } else if (command->motor == RIGHT_MOTOR) {
        // Set right motor speed
        printf("Setting right motor speed to %f\n", command->speed);
    }

    return NULL;
}

int main() {
    // Create a new thread for each motor
    pthread_t left_motor_thread, right_motor_thread;

    // Create a new robot command
    RobotCommand command;

    // Set the left motor speed to 50%
    command.left.motor = LEFT_MOTOR;
    command.left.speed = 0.5;

    // Set the right motor speed to 75%
    command.right.motor = RIGHT_MOTOR;
    command.right.speed = 0.75;

    // Start the motor control threads
    pthread_create(&left_motor_thread, NULL, motor_control_thread, &command.left);
    pthread_create(&right_motor_thread, NULL, motor_control_thread, &command.right);

    // Wait for the motor control threads to finish
    pthread_join(left_motor_thread, NULL);
    pthread_join(right_motor_thread, NULL);

    return 0;
}