//Gemma-7B DATASET v1.0 Category: Tic Tac Toe AI ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 3

typedef struct Node {
  int x;
  int y;
  struct Node* next;
} Node;

Node* createNode(int x, int y) {
  Node* node = malloc(sizeof(Node));
  node->x = x;
  node->y = y;
  node->next = NULL;
  return node;
}

void playTicTacToe() {
  int i, j, move = 0, board[BOARD_SIZE][BOARD_SIZE] = {{0, 0, 0},
    {0, 0, 0}, {0, 0, 0}};

  // Seed the random number generator
  srand(time(NULL));

  // Place the AI's first move randomly
  move = rand() % 9;
  board[move / BOARD_SIZE][move % BOARD_SIZE] = 2;

  // Loop until the game is over
  while (!board[0][0] && board[0][1] && board[0][2] && board[1][0] && board[1][1] && board[1][2] && board[2][0] && board[2][1] && board[2][2]) {
    // Get the player's move
    int movePlayer = getMove();

    // Place the player's move on the board
    board[movePlayer / BOARD_SIZE][movePlayer % BOARD_SIZE] = 1;

    // Check if the player has won
    if (checkWin(board, movePlayer)) {
      printf("You have won!");
      break;
    }

    // If the board is full, it's a draw
    if (move >= 9) {
      printf("It's a draw!");
      break;
    }

    // Make the AI's next move
    move = rand() % 9;
    board[move / BOARD_SIZE][move % BOARD_SIZE] = 2;
  }

  // Print the final board
  for (i = 0; i < BOARD_SIZE; i++) {
    for (j = 0; j < BOARD_SIZE; j++) {
      printf("%d ", board[i][j]);
    }
    printf("\n");
  }
}

int getMove() {
  int move;

  // Get the player's move
  printf("Enter your move (1-9): ");
  scanf("%d", &move);

  // Validate the move
  while (move < 1 || move > 9) {
    printf("Invalid move. Please try again: ");
    scanf("%d", &move);
  }

  return move;
}

int checkWin(int** board, int player) {
  // Check rows
  for (int i = 0; i < BOARD_SIZE; i++) {
    if (board[0][i] == player && board[1][i] == player && board[2][i] == player) {
      return 1;
    }
  }

  // Check columns
  for (int j = 0; j < BOARD_SIZE; j++) {
    if (board[j][0] == player && board[j][1] == player && board[j][2] == player) {
      return 1;
    }
  }

  // Check diagonals
  if (board[0][0] == player && board[1][1] == player && board[2][2] == player) {
    return 1;
  }
  if (board[0][2] == player && board[1][1] == player && board[2][0] == player) {
    return 1;
  }

  return 0;
}

int main() {
  playTicTacToe();

  return 0;
}