//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>

// Define a structure for a room
typedef struct room {
    int number;
    char type;
    int availability;
    int price;
} room_t;

// Define a structure for a guest
typedef struct guest {
    char name[50];
    int room_number;
    int days_stayed;
    float total_cost;
} guest_t;

// Create an array of rooms
room_t rooms[10] = {
    {1, 'A', 1, 100},
    {2, 'B', 0, 120},
    {3, 'A', 1, 100},
    {4, 'B', 0, 120},
    {5, 'A', 1, 100},
    {6, 'B', 0, 120},
    {7, 'A', 1, 100},
    {8, 'B', 0, 120},
    {9, 'A', 1, 100},
    {10, 'B', 0, 120}
};

// Create an array of guests
guest_t guests[10] = {
    {"John Doe", 1, 3, 300.0},
    {"Jane Doe", 2, 2, 240.0},
    {"Peter Pan", 3, 4, 480.0},
    {"Mary Poppins", 4, 2, 240.0},
    {"The Wizard of Oz", 5, 2, 240.0},
    {"The Little Mermaid", 6, 1, 180.0},
    {"Snow White", 7, 3, 300.0},
    {"Sleeping Beauty", 8, 2, 240.0},
    {"Cinderella", 9, 2, 240.0},
    {"Alice in Wonderland", 10, 2, 240.0}
};

// Function to check room availability
int check_room_availability(int room_number) {
    for (int i = 0; i < 10; i++) {
        if (rooms[i].number == room_number && rooms[i].availability == 1) {
            return 1;
        }
    }

    return 0;
}

// Function to calculate guest total cost
float calculate_guest_total_cost(int days_stayed, int room_price) {
    return days_stayed * room_price;
}

// Function to print guest information
void print_guest_information(guest_t guest) {
    printf("Name: %s\n", guest.name);
    printf("Room Number: %d\n", guest.room_number);
    printf("Days Stayed: %d\n", guest.days_stayed);
    printf("Total Cost: %.2f\n", guest.total_cost);
}

int main() {
    // Print room information
    for (int i = 0; i < 10; i++) {
        printf("Room Number: %d\n", rooms[i].number);
        printf("Type: %c\n", rooms[i].type);
        printf("Availability: %d\n", rooms[i].availability);
        printf("Price: %d\n", rooms[i].price);
        printf("\n");
    }

    // Print guest information
    for (int i = 0; i < 10; i++) {
        print_guest_information(guests[i]);
        printf("\n");
    }

    return 0;
}