//GPT-4o-mini DATASET v1.0 Category: System boot optimizer ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define NUM_TASKS 5

// Function prototypes
void *boot_task(void *arg);
void optimize_boot_time();

// Structure to hold task data
typedef struct {
    int task_id;
    char task_name[20];
} Task;

// Array to hold all tasks
Task tasks[NUM_TASKS] = {
    {0, "Loading OS"},
    {1, "Initializing Hardware"},
    {2, "Starting Services"},
    {3, "Configuring Network"},
    {4, "Running User Scripts"}
};

// Function to simulate a boot task
void *boot_task(void *arg) {
    Task *task = (Task *)arg;

    printf("Task %d: %s started...\n", task->task_id, task->task_name);
    sleep(rand() % 3 + 1);  // Simulate variable processing time
    printf("Task %d: %s completed.\n", task->task_id, task->task_name);
    pthread_exit(NULL);
}

// Optimizer function to run boot tasks in parallel
void optimize_boot_time() {
    pthread_t threads[NUM_TASKS];

    printf("Boot optimization started...\n");

    for (int i = 0; i < NUM_TASKS; i++) {
        if (pthread_create(&threads[i], NULL, boot_task, (void *)&tasks[i])) {
            fprintf(stderr, "Error creating thread for task %d\n", i);
            exit(1);
        }
    }

    // Wait for all threads to complete
    for (int i = 0; i < NUM_TASKS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("All boot tasks completed. Boot optimization finished!\n");
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    optimize_boot_time(); // Start the boot optimization process 

    return 0;
}