//Falcon-180B DATASET v1.0 Category: Searching algorithm ; Style: energetic
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 1000

typedef struct {
    int data;
    int index;
} Node;

void insert(Node *arr, int data, int *size) {
    if (*size == MAX_SIZE) {
        printf("Array is full. Cannot insert %d.\n", data);
        return;
    }

    int i = 0;
    while (i < *size && arr[i].data < data) {
        i++;
    }

    for (int j = *size; j > i; j--) {
        arr[j].index = j - 1;
    }

    arr[i].data = data;
    arr[i].index = i;
    (*size)++;
}

void search(Node *arr, int size, int data) {
    int index = -1;

    for (int i = 0; i < size; i++) {
        if (arr[i].data == data) {
            index = arr[i].index;
            break;
        }
    }

    if (index == -1) {
        printf("Element not found.\n");
    } else {
        printf("Element found at index %d.\n", index);
    }
}

int main() {
    Node arr[MAX_SIZE];
    int size = 0;

    insert(arr, 5, &size);
    insert(arr, 2, &size);
    insert(arr, 8, &size);
    insert(arr, 1, &size);

    printf("Sorted array:\n");
    for (int i = 0; i < size; i++) {
        printf("%d ", arr[i].data);
    }

    int data = 5;
    search(arr, size, data);

    return 0;
}