//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define WIDTH 32
#define HEIGHT 16

#define PIXEL_ON "#"
#define PIXEL_OFF "."

typedef struct {
    char canvas[HEIGHT][WIDTH + 1];
} PixelArt;

void initializeCanvas(PixelArt *art) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            art->canvas[y][x] = ' ';
        }
        art->canvas[y][WIDTH] = '\0'; // null-terminate the string
    }
}

void setPixel(PixelArt *art, int x, int y, int color) {
    if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT) {
        art->canvas[y][x] = (color) ? PIXEL_ON[0] : PIXEL_OFF[0];
    }
}

void drawRectangle(PixelArt *art, int startX, int startY, int width, int height, int color) {
    for (int y = startY; y < startY + height; y++) {
        for (int x = startX; x < startX + width; x++) {
            setPixel(art, x, y, color);
        }
    }
}

void drawCircle(PixelArt *art, int centerX, int centerY, int radius, int color) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            int dx = x - centerX;
            int dy = y - centerY;
            if (dx * dx + dy * dy <= radius * radius) {
                setPixel(art, x, y, color);
            }
        }
    }
}

void printCanvas(const PixelArt *art) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            printf("%c", art->canvas[y][x]);
        }
        printf("\n");
    }
}

void clearCanvas(PixelArt *art) {
    initializeCanvas(art);
}

int main() {
    PixelArt art;
    initializeCanvas(&art);

    // Draw a big rectangle
    drawRectangle(&art, 2, 1, 10, 5, 1);

    // Draw a circle in the middle
    drawCircle(&art, 15, 8, 4, 1);

    // Clear the canvas and draw a border of rectangles
    clearCanvas(&art);
    for (int x = 0; x < WIDTH; x++) {
        if (x % 4 == 0) {
            drawRectangle(&art, x, 0, 1, HEIGHT, 1);
        }
    }

    // Print the canvas
    printCanvas(&art);
    
    return 0;
}