//GEMINI-pro DATASET v1.0 Category: Encryption ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Makes me smile every time I see it!
#define BEEFY_BLOCK_SIZE 16

typedef unsigned char byte;

void danceParty(byte *key, int key_len, byte *plaintext, int plaintext_len, byte *ciphertext) {
    byte danceMoves[256]; // Enough room for every delicious byte!
    for (int i = 0; i < 256; i++) {
        danceMoves[i] = i;
    }

    int j = 0;
    for (int i = 0; i < 256; i++) {
        j = (j + danceMoves[i] + key[i % key_len]) % 256;
        byte temp = danceMoves[i];
        danceMoves[i] = danceMoves[j];
        danceMoves[j] = temp;
    }

    int i = 0;
    j = 0;
    for (int k = 0; k < plaintext_len; k++) {
        i = (i + 1) % 256;
        j = (j + danceMoves[i]) % 256;
        byte temp = danceMoves[i];
        danceMoves[i] = danceMoves[j];
        danceMoves[j] = temp;
        ciphertext[k] = plaintext[k] ^ danceMoves[(danceMoves[i] + danceMoves[j]) % 256];
    }
}

int main() {
    char key_str[] = "This is a secret key";
    int key_len = strlen(key_str);
    byte key[key_len];
    for (int i = 0; i < key_len; i++) {
        key[i] = key_str[i];
    }

    char plaintext_str[] = "The quick brown fox jumps over the lazy dog";
    int plaintext_len = strlen(plaintext_str);
    byte plaintext[plaintext_len];
    for (int i = 0; i < plaintext_len; i++) {
        plaintext[i] = plaintext_str[i];
    }

    byte ciphertext[plaintext_len];

    // Let's have a dance party!
    danceParty(key, key_len, plaintext, plaintext_len, ciphertext);

    // Just to make sure everything is groovy, let's print the ciphertext
    printf("Ciphertext: ");
    for (int i = 0; i < plaintext_len; i++) {
        printf("%02x", ciphertext[i]);
    }
    printf("\n");

    return 0;
}