//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: detailed
#include <stdio.h>
#include <stdlib.h>

// Structure to store process information
typedef struct Process {
    int pid;        // Process ID
    int arrival_time; // Arrival time
    int burst_time;  // Burst time
    int priority;    // Priority
    int waiting_time; // Waiting time
    int turnaround_time; // Turnaround time
} Process;

// Function to compare processes based on their arrival time
int compare_arrival_time(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p1->arrival_time - p2->arrival_time;
}

// Function to compare processes based on their priority
int compare_priority(const void *a, const void *b) {
    const Process *p1 = (const Process *)a;
    const Process *p2 = (const Process *)b;
    return p1->priority - p2->priority;
}

// Function to find the waiting time for each process
void calculate_waiting_time(Process *processes, int num_processes) {
    int current_time = 0; // Current time
    for (int i = 0; i < num_processes; i++) {
        // Calculate the waiting time for the current process
        processes[i].waiting_time = current_time - processes[i].arrival_time;
        // Update the current time
        current_time += processes[i].burst_time;
    }
}

// Function to find the turnaround time for each process
void calculate_turnaround_time(Process *processes, int num_processes) {
    for (int i = 0; i < num_processes; i++) {
        // Calculate the turnaround time for the current process
        processes[i].turnaround_time = processes[i].waiting_time + processes[i].burst_time;
    }
}

// Function to print the scheduling results
void print_scheduling_results(Process *processes, int num_processes) {
    printf("Scheduling Results:\n");
    printf("-------------------\n");
    printf("PID\tArrival Time\tBurst Time\tPriority\tWaiting Time\tTurnaround Time\n");
    for (int i = 0; i < num_processes; i++) {
        printf("%d\t%d\t%d\t%d\t%d\t%d\n", processes[i].pid, processes[i].arrival_time, processes[i].burst_time, processes[i].priority, processes[i].waiting_time, processes[i].turnaround_time);
    }
}

int main() {
    // Initialize the processes
    Process processes[] = {
        {1, 0, 5, 2},
        {2, 2, 3, 1},
        {3, 4, 4, 3},
        {4, 6, 2, 2},
        {5, 8, 1, 1},
    };
    const int num_processes = sizeof(processes) / sizeof(Process);

    // Sort the processes based on their arrival time
    qsort(processes, num_processes, sizeof(Process), compare_arrival_time);

    // Calculate the waiting time and turnaround time for each process
    calculate_waiting_time(processes, num_processes);
    calculate_turnaround_time(processes, num_processes);

    // Print the scheduling results
    print_scheduling_results(processes, num_processes);

    return 0;
}