//GEMINI-pro DATASET v1.0 Category: Poker Game ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_CARDS 52
#define NUM_PLAYERS 4
#define NUM_RANKS 13
#define NUM_SUITS 4

typedef enum {
  CLUBS,
  DIAMONDS,
  HEARTS,
  SPADES
} suit_t;

typedef enum {
  TWO,
  THREE,
  FOUR,
  FIVE,
  SIX,
  SEVEN,
  EIGHT,
  NINE,
  TEN,
  JACK,
  QUEEN,
  KING,
  ACE
} rank_t;

typedef struct {
  rank_t rank;
  suit_t suit;
} card_t;

typedef struct {
  card_t cards[NUM_CARDS];
  int num_cards;
} deck_t;

typedef struct {
  card_t cards[NUM_PLAYERS][NUM_CARDS];
  int num_cards[NUM_PLAYERS];
} hand_t;

void shuffle_deck(deck_t *deck) {
  int i, j;
  card_t temp;

  for (i = 0; i < NUM_CARDS; i++) {
    j = rand() % NUM_CARDS;
    temp = deck->cards[i];
    deck->cards[i] = deck->cards[j];
    deck->cards[j] = temp;
  }
}

void deal_cards(deck_t *deck, hand_t *hand) {
  int i, j;

  for (i = 0; i < NUM_PLAYERS; i++) {
    for (j = 0; j < NUM_CARDS; j++) {
      hand->cards[i][j] = deck->cards[j];
    }
  }
}

void print_hand(hand_t *hand) {
  int i, j;

  for (i = 0; i < NUM_PLAYERS; i++) {
    printf("Player %d's hand:\n", i + 1);
    for (j = 0; j < NUM_CARDS; j++) {
      printf("%s of %s\n", hand->cards[i][j].rank, hand->cards[i][j].suit);
    }
    printf("\n");
  }
}

int main() {
  deck_t deck;
  hand_t hand;
  int i;

  srand(time(NULL));

  for (i = 0; i < NUM_CARDS; i++) {
    deck.cards[i].rank = i % NUM_RANKS;
    deck.cards[i].suit = i / NUM_RANKS;
  }

  shuffle_deck(&deck);
  deal_cards(&deck, &hand);
  print_hand(&hand);

  return 0;
}