//Falcon-180B DATASET v1.0 Category: Elevator Simulation ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_FLOORS 10
#define NUM_PASSENGERS 20
#define MAX_WAIT_TIME 10

int main() {
    int num_passengers_in_elevator = 0;
    int current_floor = 0;
    int destination_floors[NUM_PASSENGERS];
    int num_passengers_waiting = 0;
    int waiting_passengers_floors[NUM_PASSENGERS];
    int wait_time = 0;

    srand(time(0));

    for (int i = 0; i < NUM_PASSENGERS; i++) {
        destination_floors[i] = rand() % NUM_FLOORS;
        waiting_passengers_floors[i] = destination_floors[i];
    }

    while (1) {
        printf("Current floor: %d\n", current_floor);

        if (num_passengers_in_elevator == 0) {
            if (num_passengers_waiting > 0) {
                int j = rand() % num_passengers_waiting;
                current_floor = waiting_passengers_floors[j];
                num_passengers_in_elevator = 1;
                num_passengers_waiting--;
                wait_time = 0;
            } else {
                current_floor = 0;
            }
        }

        if (num_passengers_in_elevator > 0) {
            for (int i = 0; i < NUM_PASSENGERS; i++) {
                if (destination_floors[i] == current_floor) {
                    printf("Passenger %d reached their destination.\n", i + 1);
                    destination_floors[i] = -1;
                }
            }

            if (wait_time >= MAX_WAIT_TIME) {
                current_floor = waiting_passengers_floors[0];
                num_passengers_in_elevator--;
                num_passengers_waiting--;
                wait_time = 0;
            } else {
                wait_time++;
            }
        }

        if (num_passengers_waiting == 0 && num_passengers_in_elevator == 0) {
            printf("All passengers have reached their destinations.\n");
            break;
        }
    }

    return 0;
}