//GEMINI-pro DATASET v1.0 Category: System administration ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define BUFSIZE 1024
#define MAX_CMD_LENGTH 100

int main() {
  int fd;
  char buf[BUFSIZE];
  char cmd[MAX_CMD_LENGTH];
  int ret;

  // Open the file for reading and writing
  fd = open("example.txt", O_RDWR | O_CREAT, S_IRUSR | S_IWUSR);
  if (fd == -1) {
    perror("open");
    return EXIT_FAILURE;
  }

  // Write some data to the file
  ret = write(fd, "Hello, world!\n", 13);
  if (ret == -1) {
    perror("write");
    close(fd);
    return EXIT_FAILURE;
  }

  // Seek to the beginning of the file
  ret = lseek(fd, 0, SEEK_SET);
  if (ret == -1) {
    perror("lseek");
    close(fd);
    return EXIT_FAILURE;
  }

  // Read the data from the file
  ret = read(fd, buf, BUFSIZE);
  if (ret == -1) {
    perror("read");
    close(fd);
    return EXIT_FAILURE;
  }

  // Print the data to the console
  printf("%s", buf);

  // Close the file
  close(fd);

  // Get the current working directory
  ret = getcwd(cmd, MAX_CMD_LENGTH);
  if (ret == NULL) {
    perror("getcwd");
    return EXIT_FAILURE;
  }

  // Print the current working directory
  printf("Current working directory: %s\n", cmd);

  // Change the current working directory
  ret = chdir("/tmp");
  if (ret == -1) {
    perror("chdir");
    return EXIT_FAILURE;
  }

  // Get the current working directory again
  ret = getcwd(cmd, MAX_CMD_LENGTH);
  if (ret == NULL) {
    perror("getcwd");
    return EXIT_FAILURE;
  }

  // Print the current working directory
  printf("New current working directory: %s\n", cmd);

  return EXIT_SUCCESS;
}