//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: curious
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESSORS 4

typedef struct process {
    int process_id;
    int burst_time;
    int waiting_time;
    int turn_around_time;
} process;

process processes[MAX_PROCESSORS];

void round_robin(int quantum) {
    int i = 0;
    for (int j = 0; j < quantum; j++) {
        for (i = 0; i < MAX_PROCESSORS; i++) {
            if (processes[i].burst_time > 0) {
                processes[i].burst_time--;
                processes[i].waiting_time++;
            }
        }
    }
}

void calculate_turn_around_time() {
    for (int i = 0; i < MAX_PROCESSORS; i++) {
        processes[i].turn_around_time = processes[i].waiting_time + processes[i].burst_time;
    }
}

int main() {
    processes[0].process_id = 1;
    processes[0].burst_time = 5;
    processes[0].waiting_time = 0;
    processes[0].turn_around_time = 0;

    processes[1].process_id = 2;
    processes[1].burst_time = 3;
    processes[1].waiting_time = 0;
    processes[1].turn_around_time = 0;

    processes[2].process_id = 3;
    processes[2].burst_time = 8;
    processes[2].waiting_time = 0;
    processes[2].turn_around_time = 0;

    processes[3].process_id = 4;
    processes[3].burst_time = 2;
    processes[3].waiting_time = 0;
    processes[3].turn_around_time = 0;

    round_robin(3);

    calculate_turn_around_time();

    for (int i = 0; i < MAX_PROCESSORS; i++) {
        printf("Process ID: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].process_id, processes[i].waiting_time, processes[i].turn_around_time);
    }

    return 0;
}