//Gemma-7B DATASET v1.0 Category: Warehouse Management System ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the structure of a warehouse item
typedef struct Item {
    char name[50];
    int quantity;
    float price;
} Item;

// Define the inventory list
Item inventory[100];

// Function to add an item to the inventory
void addItem(char *name, int quantity, float price) {
    // Find an empty slot in the inventory
    int i = 0;
    for (; i < 100 && inventory[i].name[0] != '\0'; i++) {}

    // Create a new item
    Item newItem;
    strcpy(newItem.name, name);
    newItem.quantity = quantity;
    newItem.price = price;

    // Add the new item to the inventory
    inventory[i] = newItem;
}

// Function to search for an item in the inventory
Item *searchItem(char *name) {
    // Iterate over the inventory to find the item
    int i = 0;
    for (; i < 100 && inventory[i].name[0] != '\0'; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            return &inventory[i];
        }
    }

    // Return NULL if the item is not found
    return NULL;
}

// Function to update the quantity of an item
void updateQuantity(char *name, int quantity) {
    // Find the item in the inventory
    Item *item = searchItem(name);

    // If the item is found, update its quantity
    if (item) {
        item->quantity = quantity;
    }
}

// Function to delete an item from the inventory
void deleteItem(char *name) {
    // Find the item in the inventory
    Item *item = searchItem(name);

    // If the item is found, delete it from the inventory
    if (item) {
        item->name[0] = '\0';
    }
}

int main() {
    // Add some items to the inventory
    addItem("John Doe", 10, 100.0);
    addItem("Jane Doe", 5, 200.0);
    addItem("Bill Smith", 7, 300.0);

    // Search for an item in the inventory
    Item *item = searchItem("John Doe");

    // If the item is found, print its name and quantity
    if (item) {
        printf("Name: %s\n", item->name);
        printf("Quantity: %d\n", item->quantity);
    }

    // Update the quantity of an item
    updateQuantity("Jane Doe", 15);

    // Delete an item from the inventory
    deleteItem("Bill Smith");

    return 0;
}