//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_STOCK_NUM 10

typedef struct Stock
{
    char name[20];
    double current_price;
    double previous_price;
    double change_percentage;
} Stock;

Stock stocks[MAX_STOCK_NUM];

void calculate_change_percentage(Stock *stock)
{
    double change = stock->current_price - stock->previous_price;
    stock->change_percentage = (change / stock->previous_price) * 100.0;
}

void display_stocks(void)
{
    printf("------------------------------------------------------------\n");
    printf("Stock Name\t\tCurrent Price\t\tPrevious Price\t\tChange Percentage\n");
    printf("------------------------------------------------------------\n");

    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        printf("%s\t\t%.2lf\t\t%.2lf\t\t%.2lf%%\n", stocks[i].name, stocks[i].current_price, stocks[i].previous_price, stocks[i].change_percentage);
    }

    printf("------------------------------------------------------------\n");
}

int main()
{
    // Initialize stocks
    for (int i = 0; i < MAX_STOCK_NUM; i++)
    {
        strcpy(stocks[i].name, "");
        stocks[i].current_price = 0.0;
        stocks[i].previous_price = 0.0;
        stocks[i].change_percentage = 0.0;
    }

    // Calculate change percentage for each stock
    calculate_change_percentage(stocks);

    // Display stocks
    display_stocks();

    return 0;
}