//Code Llama-13B DATASET v1.0 Category: Building a POP3 Client ; Style: sophisticated
/*
 * POP3 Client Example Program
 *
 * This program demonstrates how to build a POP3 client in C.
 * It connects to a POP3 server, retrieves a message, and prints its content.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define POP3_PORT 110
#define MAX_BUFFER_SIZE 1024

int main() {
  int sockfd, n, res;
  char buffer[MAX_BUFFER_SIZE];
  struct sockaddr_in server_addr;
  char *server_ip = "pop.example.com";
  char *server_port = "110";

  // Create a socket
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("socket failed");
    exit(1);
  }

  // Initialize server address
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(POP3_PORT);
  res = inet_pton(AF_INET, server_ip, &server_addr.sin_addr);
  if (res < 0) {
    perror("inet_pton failed");
    exit(1);
  }

  // Connect to server
  res = connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr));
  if (res < 0) {
    perror("connect failed");
    exit(1);
  }

  // Receive greeting message
  n = recv(sockfd, buffer, MAX_BUFFER_SIZE, 0);
  if (n < 0) {
    perror("recv failed");
    exit(1);
  }
  printf("Server greeting: %s\n", buffer);

  // Send username
  char username[] = "user@example.com";
  n = send(sockfd, username, strlen(username), 0);
  if (n < 0) {
    perror("send failed");
    exit(1);
  }

  // Send password
  char password[] = "password";
  n = send(sockfd, password, strlen(password), 0);
  if (n < 0) {
    perror("send failed");
    exit(1);
  }

  // Receive message list
  n = recv(sockfd, buffer, MAX_BUFFER_SIZE, 0);
  if (n < 0) {
    perror("recv failed");
    exit(1);
  }
  printf("Message list: %s\n", buffer);

  // Send message ID
  char message_id[] = "1";
  n = send(sockfd, message_id, strlen(message_id), 0);
  if (n < 0) {
    perror("send failed");
    exit(1);
  }

  // Receive message
  n = recv(sockfd, buffer, MAX_BUFFER_SIZE, 0);
  if (n < 0) {
    perror("recv failed");
    exit(1);
  }
  printf("Message: %s\n", buffer);

  // Close socket
  close(sockfd);

  return 0;
}