//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 50

// File system structure
typedef struct {
    char filename[MAX_FILE_NAME_LENGTH];
    int size;
    int is_deleted;
} File;

// File system
File fs[MAX_FILES];
int num_files = 0;

// Initialize the file system
void init_fs() {
    for (int i = 0; i < MAX_FILES; i++) {
        fs[i].is_deleted = 1;
    }
    num_files = 0;
}

// Create a new file
void create_file(char* filename, int size) {
    for (int i = 0; i < num_files; i++) {
        if (fs[i].is_deleted) {
            strcpy(fs[i].filename, filename);
            fs[i].size = size;
            fs[i].is_deleted = 0;
            num_files++;
            return;
        }
    }
    printf("File system full.\n");
}

// Delete a file
void delete_file(char* filename) {
    for (int i = 0; i < num_files; i++) {
        if (strcmp(fs[i].filename, filename) == 0 &&!fs[i].is_deleted) {
            fs[i].is_deleted = 1;
            return;
        }
    }
    printf("File not found.\n");
}

// List all files
void list_files() {
    printf("Files:\n");
    for (int i = 0; i < num_files; i++) {
        if (!fs[i].is_deleted) {
            printf("%s (%d bytes)\n", fs[i].filename, fs[i].size);
        }
    }
}

int main() {
    init_fs();
    create_file("test.txt", 10);
    create_file("example.bin", 100);
    list_files();
    delete_file("test.txt");
    list_files();
    return 0;
}