//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

/* Temperature Monitor Program */

typedef struct {
    char name[20];
    float temperature;
} temperature_t;

void add_temperature(temperature_t *temps, int *size, char *name, float temp) {
    if (*size >= 100) {
        printf("Error: Temperature list is full.\n");
        return;
    }
    strcpy(temps[*size].name, name);
    temps[*size].temperature = temp;
    (*size)++;
}

void display_temperatures(temperature_t *temps, int size) {
    printf("Temperature List:\n");
    for (int i = 0; i < size; i++) {
        printf("%s: %.2f\n", temps[i].name, temps[i].temperature);
    }
}

void sort_temperatures(temperature_t *temps, int size) {
    for (int i = 0; i < size - 1; i++) {
        for (int j = i + 1; j < size; j++) {
            if (temps[j].temperature < temps[i].temperature) {
                temperature_t temp = temps[i];
                temps[i] = temps[j];
                temps[j] = temp;
            }
        }
    }
}

int main() {
    temperature_t temps[100];
    int size = 0;

    add_temperature(temps, &size, "CPU", 45.6);
    add_temperature(temps, &size, "GPU", 60.2);
    add_temperature(temps, &size, "Motherboard", 35.7);
    add_temperature(temps, &size, "Hard Drive", 40.1);

    display_temperatures(temps, size);

    sort_temperatures(temps, size);

    printf("\nSorted Temperature List:\n");
    display_temperatures(temps, size);

    return 0;
}