//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>

// Define the structure of a product
typedef struct {
    char name[100];
    int quantity;
    double price;
} Product;

// Function to add a product to the inventory
void addProduct(Product* inventory, int size, int capacity, char* name, int quantity, double price) {
    for (int i = 0; i < size; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i].quantity += quantity;
            return;
        }
    }

    if (size >= capacity) {
        printf("Inventory is full. Cannot add product.\n");
        return;
    }

    strcpy(inventory[size].name, name);
    inventory[size].quantity = quantity;
    inventory[size].price = price;
    size++;
}

// Function to remove a product from the inventory
void removeProduct(Product* inventory, int size, char* name) {
    for (int i = 0; i < size; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i].quantity = 0;
            return;
        }
    }

    printf("Product not found in inventory.\n");
}

// Function to update the quantity of a product in the inventory
void updateQuantity(Product* inventory, int size, char* name, int quantity) {
    for (int i = 0; i < size; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            inventory[i].quantity = quantity;
            return;
        }
    }

    printf("Product not found in inventory.\n");
}

// Function to display the inventory
void displayInventory(Product* inventory, int size) {
    printf("Inventory:\n");
    for (int i = 0; i < size; i++) {
        if (inventory[i].quantity > 0) {
            printf("%s - %d units - $%.2f each\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
        }
    }
}

// Main function
int main() {
    Product inventory[100];
    int size = 0;

    // Initialize the inventory with some products
    addProduct(inventory, size, 100, "Apples", 50, 1.00);
    addProduct(inventory, size, 100, "Oranges", 25, 0.75);

    // Display the initial inventory
    displayInventory(inventory, size);

    // Update the quantity of a product
    updateQuantity(inventory, size, "Apples", 75);

    // Display the updated inventory
    displayInventory(inventory, size);

    // Remove a product from the inventory
    removeProduct(inventory, size, "Oranges");

    // Display the final inventory
    displayInventory(inventory, size);

    return 0;
}