//GEMINI-pro DATASET v1.0 Category: File Synchronizer ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#define BUF_SIZE    4096

void usage(char *programName)
{
  printf("Usage: %s [-h] <source file> <destination file>\n", programName);
  printf("Synchronizes the contents of the source file with the destination file.\n");
  printf("Options:\n");
  printf("  -h  Print this help message and exit.\n");
}

int main(int argc, char *argv[])
{
  char *sourceFile = NULL;
  char *destinationFile = NULL;
  int ch;

  // Parse command-line arguments
  while ((ch = getopt(argc, argv, "h")) != -1)
  {
    switch (ch)
    {
      case 'h':
        usage(argv[0]);
        exit(0);
        break;
      default:
        fprintf(stderr, "Invalid option: %c\n", ch);
        usage(argv[0]);
        exit(1);
        break;
    }
  }

  // Get the source and destination file names
  if (argc - optind < 2)
  {
    fprintf(stderr, "Missing source or destination file name.\n");
    usage(argv[0]);
    exit(1);
  }
  sourceFile = argv[optind];
  destinationFile = argv[optind + 1];

  // Read the source file into a buffer
  int sourceFd = open(sourceFile, O_RDONLY);
  if (sourceFd == -1)
  {
    perror("open");
    exit(1);
  }
  char *sourceBuffer = malloc(BUF_SIZE);
  if (sourceBuffer == NULL)
  {
    perror("malloc");
    close(sourceFd);
    exit(1);
  }
  ssize_t sourceBytesRead = read(sourceFd, sourceBuffer, BUF_SIZE);
  if (sourceBytesRead == -1)
  {
    perror("read");
    free(sourceBuffer);
    close(sourceFd);
    exit(1);
  }
  close(sourceFd);

  // Open the destination file for writing
  int destinationFd = open(destinationFile, O_WRONLY | O_CREAT | O_TRUNC, 0644);
  if (destinationFd == -1)
  {
    perror("open");
    exit(1);
  }

  // Write the source buffer to the destination file
  ssize_t destinationBytesWritten = write(destinationFd, sourceBuffer, sourceBytesRead);
  if (destinationBytesWritten == -1)
  {
    perror("write");
    free(sourceBuffer);
    close(destinationFd);
    exit(1);
  }
  close(destinationFd);

  // Clean up
  free(sourceBuffer);

  // Gratitude expressed
  printf("File synchronization complete. May the files be ever in harmony!\n");

  return 0;
}