//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 16
#define POOL_SIZE 96

// Function to generate a random password
char* generate_password() {
    // Including upper, lower, symbols, and numbers
    char char_pool[POOL_SIZE] = "abcdefghijklmnopqrstuvwxyz"
                                 "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                                 "0123456789"
                                 "!@#$%^&*()-_=+[]{}|;:',.<>?/~`";
    char *password = (char *)malloc((PASSWORD_LENGTH + 1) * sizeof(char));
    if (!password) {
        fprintf(stderr, "Memory allocation failed!\n");
        exit(EXIT_FAILURE);
    }

    // Seed the random number generator
    srand((unsigned int)time(NULL));

    // Generate the password
    for (int i = 0; i < PASSWORD_LENGTH; i++) {
        password[i] = char_pool[rand() % POOL_SIZE];
    }
    password[PASSWORD_LENGTH] = '\0'; // null terminate the string

    return password;
}

// Function to check if the password meets complexity requirements
int validate_password(char *password) {
    int has_lower = 0, has_upper = 0, has_digit = 0, has_symbol = 0;

    for (int i = 0; i < PASSWORD_LENGTH; i++) {
        if (password[i] >= 'a' && password[i] <= 'z') has_lower = 1;
        else if (password[i] >= 'A' && password[i] <= 'Z') has_upper = 1;
        else if (password[i] >= '0' && password[i] <= '9') has_digit = 1;
        else if (strchr("!@#$%^&*()-_=+[]{}|;:',.<>?/~`", password[i])) has_symbol = 1;
    }

    return has_lower && has_upper && has_digit && has_symbol;
}

// Function to create a meaningful password report
void password_report(char *password) {
    printf("Ah, behold your newly forged password:\n");
    printf("Password: %s\n", password);
    if (validate_password(password)) {
        printf("This password is mighty secure!\n");
    } else {
        printf("Alas! It seems the password lacks strength.\n");
    }
    printf("May your digital realm stay safe!\n");
}

// Main function to orchestrate the password generation and validation
int main() {
    printf("Welcome to the Enchanted Password Generator!\n");
    printf("Creating a secure password fit for a wizard...\n");

    // Generate the password
    char *my_password = generate_password();

    // Display and validate the password
    password_report(my_password);

    // Clean up and free memory
    free(my_password);
    printf("The spell has been cast! May your password guard your treasures well!\n");

    return 0;
}