//GPT-4o-mini DATASET v1.0 Category: Sorting ; Style: Romeo and Juliet
#include <stdio.h>
#include <string.h>

void display(char *families[], int count);
void swap(char **a, char **b);
void bubbleSort(char *families[], int count);
void lovers(char *families[], int count);

int main() {
    // The two feuding families
    char *families[] = {
        "Capulet",
        "Montague",
        "Verona",
        "Prince Escalus",
        "Mercutio",
        "Benvolio",
        "Tybalt",
        "Juliet",
        "Romeo",
        "Paris"
    };

    int count = sizeof(families) / sizeof(families[0]);

    printf("Before the sorting, the lines of our play are:\n");
    display(families, count);
    
    // Sorting the names, in hopes of harmony
    bubbleSort(families, count);

    printf("\nAfter the sorting, may the feud be brought to an end:\n");
    display(families, count);
    
    // A tale of two lovers
    lovers(families, count);

    return 0;
}

// Display the names of the families
void display(char *families[], int count) {
    for (int i = 0; i < count; i++) {
        printf("%s\n", families[i]);
    }
}

// Swap function to rearrange family names
void swap(char **a, char **b) {
    char *temp = *a;
    *a = *b;
    *b = temp;
}

// Bubble sort to organize the family names
void bubbleSort(char *families[], int count) {
    for (int i = 0; i < count - 1; i++) {
        for (int j = 0; j < count - i - 1; j++) {
            if (strcmp(families[j], families[j + 1]) > 0) {
                swap(&families[j], &families[j + 1]);
            }
        }
    }
}

// A function to symbolize the lovers' plight
void lovers(char *families[], int count) {
    printf("\nAnd thus they sang: \n");
    
    for (int i = 0; i < count; i++) {
        if (strcmp(families[i], "Juliet") == 0 || strcmp(families[i], "Romeo") == 0) {
            printf("To love, to be or not to be, is this fate?\n");
            printf("Within these names, our hearts shall create,\n");
            printf("A love that conquers all, no feuds shall wait!\n");
            break;
        }
    }

    printf("\nYet here we stand, with names that were estranged,\n");
    printf("But love shall never fade, nor be deranged.\n");
    printf("In Verona's light, our paths have exchanged.\n");
}