//GEMINI-pro DATASET v1.0 Category: Email Client ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>

void print_help() {
  printf("Usage: email-client [options] -s <subject> -r <from> -t <to> <message>\n");
  printf("Options:\n");
  printf("  -h\t\tPrint this help message.\n");
  printf("  -s <subject>\tThe subject of the email.\n");
  printf("  -r <from>\tThe sender's email address.\n");
  printf("  -t <to>\tThe recipient's email address.\n");
  printf("  -m <message>\tThe body of the email.\n");
  printf("\nExamples:\n");
  printf("  email-client -s \"Hello, world!\" -r \"me@example.com\" -t \"you@example.com\" \"This is an email.\"\n");
  printf("  email-client -s \"Test email\" -r \"me@example.com\" -t \"you@example.com\" -- \"This is a test email.\"\n");
}

int main(int argc, char **argv) {
  int opt;
  char *subject = NULL;
  char *from = NULL;
  char *to = NULL;
  char *message = NULL;
  int port = 25;  // Default SMTP port
  char *hostname = "localhost";  // Default SMTP hostname

  while ((opt = getopt(argc, argv, "hs:r:t:m:")) != -1) {
    switch (opt) {
      case 'h':
        print_help();
        return 0;
      case 's':
        subject = optarg;
        break;
      case 'r':
        from = optarg;
        break;
      case 't':
        to = optarg;
        break;
      case 'm':
        message = optarg;
        break;
      default:
        fprintf(stderr, "Unknown option: %c\n", opt);
        return 1;
    }
  }

  if (argc < 5 || !subject || !from || !to || !message) {
    fprintf(stderr, "Missing required arguments.\n");
    print_help();
    return 1;
  }

  // Connect to the SMTP server
  struct sockaddr_in server_addr;
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("socket");
    return 1;
  }

  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(port);
  server_addr.sin_addr.s_addr = inet_addr(hostname);
  if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("connect");
    return 1;
  }

  // Send the HELO command
  char buffer[1024];
  snprintf(buffer, sizeof(buffer), "HELO %s\r\n", hostname);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("send");
    return 1;
  }

  // Receive the server's response
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
    perror("recv");
    return 1;
  }

  // Send the MAIL FROM command
  snprintf(buffer, sizeof(buffer), "MAIL FROM: <%s>\r\n", from);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("send");
    return 1;
  }

  // Receive the server's response
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
    perror("recv");
    return 1;
  }

  // Send the RCPT TO command
  snprintf(buffer, sizeof(buffer), "RCPT TO: <%s>\r\n", to);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("send");
    return 1;
  }

  // Receive the server's response
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
    perror("recv");
    return 1;
  }

  // Send the DATA command
  snprintf(buffer, sizeof(buffer), "DATA\r\n");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("send");
    return 1;
  }

  // Receive the server's response
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
    perror("recv");
    return 1;
  }

  // Send the email message
  snprintf(buffer, sizeof(buffer), "Subject: %s\r\nFrom: %s\r\nTo: %s\r\n\r\n%s\r\n.\r\n", subject, from, to, message);
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("send");
    return 1;
  }

  // Receive the server's response
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
    perror("recv");
    return 1;
  }

  // Send the QUIT command
  snprintf(buffer, sizeof(buffer), "QUIT\r\n");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("send");
    return 1;
  }

  // Close the socket
  close(sockfd);

  return 0;
}