//LLAMA2-13B DATASET v1.0 Category: Physics simulation ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define GRAVITY 9.8
#define WORLD_WIDTH 1000
#define WORLD_HEIGHT 500

typedef struct {
    float x;
    float y;
    float vx;
    float vy;
} Object;

Object balls[5];

void init() {
    int i;
    for (i = 0; i < 5; i++) {
        balls[i].x = (float)rand() / RAND_MAX * WORLD_WIDTH;
        balls[i].y = (float)rand() / RAND_MAX * WORLD_HEIGHT;
        balls[i].vx = (float)rand() / RAND_MAX * 2 - 1;
        balls[i].vy = (float)rand() / RAND_MAX * 2 - 1;
    }
}

void update() {
    int i;
    for (i = 0; i < 5; i++) {
        balls[i].x += balls[i].vx;
        balls[i].y += balls[i].vy;
        if (balls[i].x > WORLD_WIDTH) balls[i].vx = -balls[i].vx;
        if (balls[i].x < 0) balls[i].vx = -balls[i].vx;
        if (balls[i].y > WORLD_HEIGHT) balls[i].vy = -balls[i].vy;
        if (balls[i].y < 0) balls[i].vy = -balls[i].vy;
        balls[i].vx += GRAVITY;
        balls[i].vy += GRAVITY;
    }
}

void draw() {
    int i;
    for (i = 0; i < 5; i++) {
        printf("Object %d: x = %.2f, y = %.2f, vx = %.2f, vy = %.2f\n", i, balls[i].x, balls[i].y, balls[i].vx, balls[i].vy);
    }
}

int main() {
    srand(time(NULL));
    init();
    update();
    draw();
    return 0;
}