//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: curious
#include <stdio.h>

// Define the structure for a customer's order
struct Order {
    char* item;
    int quantity;
    float price;
};

// Define the structure for a customer's information
struct Customer {
    char name[20];
    char address[50];
    char phone[20];
};

// Define the structure for the billing system
struct Billing {
    int total_orders;
    float total_amount;
    float tax;
    float discount;
    float grand_total;
};

// Function to calculate the total amount
float calculate_total_amount(struct Order* orders, int num_orders) {
    float total = 0;
    for (int i = 0; i < num_orders; i++) {
        total += orders[i].quantity * orders[i].price;
    }
    return total;
}

// Function to calculate the tax
float calculate_tax(float total_amount) {
    return total_amount * 0.07;
}

// Function to calculate the discount
float calculate_discount(float total_amount, int num_orders) {
    if (num_orders >= 3) {
        return total_amount * 0.1;
    } else {
        return 0;
    }
}

// Function to calculate the grand total
float calculate_grand_total(float total_amount, float tax, float discount) {
    return total_amount + tax - discount;
}

// Function to print the bill
void print_bill(struct Customer* customer, struct Order* orders, int num_orders, struct Billing* billing) {
    printf("---------------------------------------------------\n");
    printf("Customer Information\n");
    printf("Name: %s\n", customer->name);
    printf("Address: %s\n", customer->address);
    printf("Phone: %s\n", customer->phone);
    printf("---------------------------------------------------\n");
    printf("Order Information\n");
    printf("Item\tQuantity\tPrice\n");
    for (int i = 0; i < num_orders; i++) {
        printf("%s\t%d\t%.2f\n", orders[i].item, orders[i].quantity, orders[i].price);
    }
    printf("---------------------------------------------------\n");
    printf("Billing Information\n");
    printf("Total Amount: %.2f\n", billing->total_amount);
    printf("Tax: %.2f\n", billing->tax);
    printf("Discount: %.2f\n", billing->discount);
    printf("Grand Total: %.2f\n", billing->grand_total);
    printf("---------------------------------------------------\n");
}

int main() {
    // Create an array of orders
    struct Order orders[3];
    orders[0].item = "Coffee";
    orders[0].quantity = 2;
    orders[0].price = 3.50;
    orders[1].item = "Tea";
    orders[1].quantity = 3;
    orders[1].price = 2.50;
    orders[2].item = "Cake";
    orders[2].quantity = 1;
    orders[2].price = 10.00;

    // Create a customer structure
    struct Customer customer;
    strcpy(customer.name, "John Doe");
    strcpy(customer.address, "123 Main St");
    strcpy(customer.phone, "555-555-5555");

    // Calculate the total amount
    float total_amount = calculate_total_amount(orders, 3);

    // Calculate the tax
    float tax = calculate_tax(total_amount);

    // Calculate the discount
    float discount = calculate_discount(total_amount, 3);

    // Calculate the grand total
    float grand_total = calculate_grand_total(total_amount, tax, discount);

    // Create a billing structure
    struct Billing billing;
    billing.total_orders = 3;
    billing.total_amount = total_amount;
    billing.tax = tax;
    billing.discount = discount;
    billing.grand_total = grand_total;

    // Print the bill
    print_bill(&customer, orders, 3, &billing);

    return 0;
}