//GEMINI-pro DATASET v1.0 Category: Hotel Management System ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROOMS 100
#define MAX_GUESTS 1000

typedef struct {
    int id;
    char *name;
    char *email;
    char *checkin;
    char *checkout;
    int room_id;
} guest;

typedef struct {
    int id;
    int number;
    int type;
    int price;
    int availability;
} room;

guest guests[MAX_GUESTS];
room rooms[MAX_ROOMS];

int num_guests = 0;
int num_rooms = 0;

void init_hotel() {
    // Create some sample rooms
    room room1 = {1, 101, 1, 100, 1};
    room room2 = {2, 102, 2, 150, 1};
    room room3 = {3, 103, 3, 200, 1};
    room room4 = {4, 104, 4, 250, 1};
    room room5 = {5, 105, 5, 300, 1};

    rooms[0] = room1;
    rooms[1] = room2;
    rooms[2] = room3;
    rooms[3] = room4;
    rooms[4] = room5;

    num_rooms = 5;
}

void add_guest(guest new_guest) {
    guests[num_guests] = new_guest;
    num_guests++;
}

void remove_guest(int guest_id) {
    for (int i = 0; i < num_guests; i++) {
        if (guests[i].id == guest_id) {
            guests[i] = guests[num_guests - 1];
            num_guests--;
            break;
        }
    }
}

void update_guest(guest updated_guest) {
    for (int i = 0; i < num_guests; i++) {
        if (guests[i].id == updated_guest.id) {
            guests[i] = updated_guest;
            break;
        }
    }
}

guest get_guest_by_id(int guest_id) {
    for (int i = 0; i < num_guests; i++) {
        if (guests[i].id == guest_id) {
            return guests[i];
        }
    }

    return (guest) {0, NULL, NULL, NULL, NULL, 0};
}

room get_room_by_id(int room_id) {
    for (int i = 0; i < num_rooms; i++) {
        if (rooms[i].id == room_id) {
            return rooms[i];
        }
    }

    return (room) {0, 0, 0, 0, 0};
}

void print_guest(guest g) {
    printf("Guest ID: %d\n", g.id);
    printf("Name: %s\n", g.name);
    printf("Email: %s\n", g.email);
    printf("Checkin: %s\n", g.checkin);
    printf("Checkout: %s\n", g.checkout);
    printf("Room ID: %d\n", g.room_id);
}

void print_room(room r) {
    printf("Room ID: %d\n", r.id);
    printf("Number: %d\n", r.number);
    printf("Type: %d\n", r.type);
    printf("Price: %d\n", r.price);
    printf("Availability: %d\n", r.availability);
}

int main() {
    init_hotel();

    // Add some sample guests
    guest guest1 = {1, "John Doe", "john.doe@example.com", "2023-01-01", "2023-01-05", 101};
    guest guest2 = {2, "Jane Doe", "jane.doe@example.com", "2023-01-02", "2023-01-06", 102};
    guest guest3 = {3, "John Smith", "john.smith@example.com", "2023-01-03", "2023-01-07", 103};

    add_guest(guest1);
    add_guest(guest2);
    add_guest(guest3);

    // Print the list of guests
    printf("Guests:\n");
    for (int i = 0; i < num_guests; i++) {
        print_guest(guests[i]);
    }

    // Print the list of rooms
    printf("Rooms:\n");
    for (int i = 0; i < num_rooms; i++) {
        print_room(rooms[i]);
    }

    return 0;
}