//GEMINI-pro DATASET v1.0 Category: Table Game ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the table size
#define TABLE_SIZE 5

// Define the number of players
#define NUM_PLAYERS 2

// Define the number of dice
#define NUM_DICE 2

// Define the maximum number on a die
#define MAX_DIE_VALUE 6

// Define the game state
enum GameState {
  ROLLING,
  MOVING,
  FINISHED
};

// Define the player struct
struct Player {
  int position;
  int score;
};

// Create the game table
int table[TABLE_SIZE][TABLE_SIZE];

// Create the players
struct Player players[NUM_PLAYERS];

// Create the dice
int dice[NUM_DICE];

// Initialize the game state
enum GameState state = ROLLING;

// Initialize the players
void init_players() {
  for (int i = 0; i < NUM_PLAYERS; i++) {
    players[i].position = 0;
    players[i].score = 0;
  }
}

// Initialize the table
void init_table() {
  for (int i = 0; i < TABLE_SIZE; i++) {
    for (int j = 0; j < TABLE_SIZE; j++) {
      table[i][j] = 0;
    }
  }
}

// Initialize the dice
void init_dice() {
  for (int i = 0; i < NUM_DICE; i++) {
    dice[i] = 0;
  }
}

// Roll the dice
void roll_dice() {
  for (int i = 0; i < NUM_DICE; i++) {
    dice[i] = rand() % MAX_DIE_VALUE + 1;
  }
}

// Move the player
void move_player(int player_index) {
  int roll_total = dice[0] + dice[1];
  int new_position = players[player_index].position + roll_total;

  if (new_position >= TABLE_SIZE * TABLE_SIZE) {
    players[player_index].position = TABLE_SIZE * TABLE_SIZE - 1;
    state = FINISHED;
  } else {
    players[player_index].position = new_position;
  }
}

// Check if the player has won
int check_win() {
  for (int i = 0; i < NUM_PLAYERS; i++) {
    if (players[i].position == TABLE_SIZE * TABLE_SIZE - 1) {
      return i;
    }
  }

  return -1;
}

// Print the game table
void print_table() {
  for (int i = 0; i < TABLE_SIZE; i++) {
    for (int j = 0; j < TABLE_SIZE; j++) {
      printf("%d ", table[i][j]);
    }
    printf("\n");
  }
}

// Print the game state
void print_state() {
  switch (state) {
    case ROLLING:
      printf("Rolling dice\n");
      break;
    case MOVING:
      printf("Moving player\n");
      break;
    case FINISHED:
      printf("Game finished\n");
      break;
  }
}

// Main game loop
int main() {
  // Initialize the game
  srand(time(NULL));
  init_players();
  init_table();
  init_dice();

  // Game loop
  while (state != FINISHED) {
    // Roll the dice
    roll_dice();

    // Print the dice roll
    printf("Dice roll: %d, %d\n", dice[0], dice[1]);

    // Move the player
    move_player(0);

    // Print the game table
    print_table();

    // Print the game state
    print_state();

    // Check if the player has won
    int winner = check_win();
    if (winner != -1) {
      printf("Player %d wins!\n", winner + 1);
      state = FINISHED;
    }
  }

  return 0;
}