//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of candidates and voters
#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

// Define the structure of a candidate
typedef struct candidate {
    char name[50];
    int votes;
} candidate_t;

// Define the structure of a voter
typedef struct voter {
    int id;
    int voted;
} voter_t;

// Define the array of candidates
candidate_t candidates[MAX_CANDIDATES];

// Define the array of voters
voter_t voters[MAX_VOTERS];

// Define the number of candidates and voters
int num_candidates = 0;
int num_voters = 0;

// Function to add a candidate
void add_candidate(char *name) {
    // Check if the maximum number of candidates has been reached
    if (num_candidates >= MAX_CANDIDATES) {
        printf("Error: Maximum number of candidates reached.\n");
        return;
    }

    // Copy the candidate's name to the array
    strcpy(candidates[num_candidates].name, name);

    // Initialize the candidate's votes to 0
    candidates[num_candidates].votes = 0;

    // Increment the number of candidates
    num_candidates++;
}

// Function to add a voter
void add_voter(int id) {
    // Check if the maximum number of voters has been reached
    if (num_voters >= MAX_VOTERS) {
        printf("Error: Maximum number of voters reached.\n");
        return;
    }

    // Copy the voter's ID to the array
    voters[num_voters].id = id;

    // Initialize the voter's voted flag to 0
    voters[num_voters].voted = 0;

    // Increment the number of voters
    num_voters++;
}

// Function to vote for a candidate
void vote(int voter_id, char *candidate_name) {
    // Find the voter by their ID
    int voter_index = -1;
    for (int i = 0; i < num_voters; i++) {
        if (voters[i].id == voter_id) {
            voter_index = i;
            break;
        }
    }

    // Check if the voter has already voted
    if (voter_index == -1 || voters[voter_index].voted) {
        printf("Error: Voter has already voted.\n");
        return;
    }

    // Find the candidate by their name
    int candidate_index = -1;
    for (int i = 0; i < num_candidates; i++) {
        if (strcmp(candidates[i].name, candidate_name) == 0) {
            candidate_index = i;
            break;
        }
    }

    // Check if the candidate is valid
    if (candidate_index == -1) {
        printf("Error: Invalid candidate.\n");
        return;
    }

    // Increment the candidate's votes
    candidates[candidate_index].votes++;

    // Set the voter's voted flag to 1
    voters[voter_index].voted = 1;
}

// Function to print the results of the election
void print_results() {
    // Find the winner of the election
    int winner_index = -1;
    int max_votes = 0;
    for (int i = 0; i < num_candidates; i++) {
        if (candidates[i].votes > max_votes) {
            winner_index = i;
            max_votes = candidates[i].votes;
        }
    }

    // Print the name of the winner
    printf("The winner of the election is: %s\n", candidates[winner_index].name);

    // Print the total number of votes cast
    int total_votes = 0;
    for (int i = 0; i < num_candidates; i++) {
        total_votes += candidates[i].votes;
    }
    printf("Total votes cast: %d\n", total_votes);
}

// Main function
int main() {
    // Add some candidates to the election
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Charlie");

    // Add some voters to the election
    add_voter(1);
    add_voter(2);
    add_voter(3);

    // Have the voters vote for a candidate
    vote(1, "Alice");
    vote(2, "Bob");
    vote(3, "Charlie");

    // Print the results of the election
    print_results();

    return 0;
}