//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

#define AES_KEY_LENGTH 128  // AES key size in bits
#define BLOCK_SIZE 16        // AES block size in bytes

void handleErrors() {
    fprintf(stderr, "An error occurred!\n");
    exit(EXIT_FAILURE);
}

void encrypt(const unsigned char *key, const unsigned char *input, unsigned char *output) {
    AES_KEY encryptKey;
    if (AES_set_encrypt_key(key, AES_KEY_LENGTH, &encryptKey) < 0) {
        handleErrors();
    }
    AES_encrypt(input, output, &encryptKey);
}

void decrypt(const unsigned char *key, const unsigned char *input, unsigned char *output) {
    AES_KEY decryptKey;
    if (AES_set_decrypt_key(key, AES_KEY_LENGTH, &decryptKey) < 0) {
        handleErrors();
    }
    AES_decrypt(input, output, &decryptKey);
}

void generateRandomKey(unsigned char *key) {
    if (!RAND_bytes(key, AES_KEY_LENGTH / 8)) {
        handleErrors();
    }
}

void printHex(const char *label, unsigned char *data, int len) {
    printf("%s: ", label);
    for (int i = 0; i < len; i++) {
        printf("%02x", data[i]);
    }
    printf("\n");
}

int main() {
    unsigned char key[AES_KEY_LENGTH / 8]; // 16 bytes for AES-128
    generateRandomKey(key); // Generate a random key

    const char *plaintext = "This is a secret message!";
    unsigned char input[BLOCK_SIZE];
    unsigned char encrypted[BLOCK_SIZE];
    unsigned char decrypted[BLOCK_SIZE];

    // Pad the plaintext to fit in a block
    memset(input, 0, BLOCK_SIZE);
    strncpy((char *)input, plaintext, BLOCK_SIZE);

    // Encrypt the input
    encrypt(key, input, encrypted);
    printHex("Encrypted", encrypted, BLOCK_SIZE);
    
    // Decrypt the encrypted data
    decrypt(key, encrypted, decrypted);
    printHex("Decrypted", decrypted, BLOCK_SIZE);
    
    // Show decrypted data in string format
    decrypted[BLOCK_SIZE - 1] = '\0'; // Null-terminate for printing
    printf("Decrypted Message: %s\n", decrypted);

    return 0;
}