//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>

#define NUM_BITS 32

void printBinary(unsigned int num) {
    int i;
    for (i = 0; i < NUM_BITS; i++) {
        printf("%d", (num >> i) & 1);
    }
    printf("\n");
}

int main() {
    int num1 = 10;
    int num2 = 7;

    // Bitwise AND
    printf("Bitwise AND: ");
    printf("%d\n", num1 & num2);

    // Bitwise OR
    printf("Bitwise OR: ");
    printf("%d\n", num1 | num2);

    // Bitwise XOR
    printf("Bitwise XOR: ");
    printf("%d\n", num1 ^ num2);

    // Left Shift
    printf("Left Shift: ");
    printf("%d\n", num1 << 2);

    // Right Shift
    printf("Right Shift: ");
    printf("%d\n", num1 >> 2);

    // Bitwise NOT
    printf("Bitwise NOT: ");
    printf("%d\n", ~num1);

    // Bitwise AND with a number
    printf("Bitwise AND with a number: ");
    printf("%d\n", num1 & 3);

    // Bitwise OR with a number
    printf("Bitwise OR with a number: ");
    printf("%d\n", num1 | 3);

    // Bitwise XOR with a number
    printf("Bitwise XOR with a number: ");
    printf("%d\n", num1 ^ 3);

    // Bitwise NOT with a number
    printf("Bitwise NOT with a number: ");
    printf("%d\n", ~3);

    // Bitwise AND with a bit pattern
    printf("Bitwise AND with a bit pattern: ");
    int bitPattern = 0b10101010;
    printf("%d\n", num1 & bitPattern);

    // Bitwise OR with a bit pattern
    printf("Bitwise OR with a bit pattern: ");
    printf("%d\n", num1 | bitPattern);

    // Bitwise XOR with a bit pattern
    printf("Bitwise XOR with a bit pattern: ");
    printf("%d\n", num1 ^ bitPattern);

    // Bitwise NOT with a bit pattern
    printf("Bitwise NOT with a bit pattern: ");
    printf("%d\n", ~bitPattern);

    return 0;
}