//GPT-4o-mini DATASET v1.0 Category: Queue Implementation ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX 100  // Maximum size for the queue

// Structure to represent a queue
typedef struct Queue {
    int items[MAX];
    int front;
    int rear;
} Queue;

// Function to create a new queue
Queue* createQueue() {
    Queue* queue = (Queue*)malloc(sizeof(Queue));
    if (!queue) {
        fprintf(stderr, "Memory allocation failed\n");
        exit(EXIT_FAILURE);
    }
    queue->front = -1;
    queue->rear = -1;
    return queue;
}

// Function to check if the queue is empty
bool isEmpty(Queue* queue) {
    return queue->rear == -1;
}

// Function to check if the queue is full
bool isFull(Queue* queue) {
    return ((queue->rear + 1) % MAX == queue->front);
}

// Function to add an element to the queue
void enqueue(Queue* queue, int value) {
    if (isFull(queue)) {
        printf("Queue is full. Cannot enqueue %d\n", value);
        return;
    }
    if (queue->front == -1) {
        queue->front = 0;
    }
    queue->rear = (queue->rear + 1) % MAX;
    queue->items[queue->rear] = value;
    printf("Enqueued: %d\n", value);
}

// Function to remove an element from the queue
int dequeue(Queue* queue) {
    if (isEmpty(queue)) {
        printf("Queue is empty. Cannot dequeue\n");
        return -1;
    }
    int item = queue->items[queue->front];
    if (queue->front == queue->rear) {
        queue->front = -1;
        queue->rear = -1;
    } else {
        queue->front = (queue->front + 1) % MAX;
    }
    printf("Dequeued: %d\n", item);
    return item;
}

// Function to display the queue
void displayQueue(Queue* queue) {
    if (isEmpty(queue)) {
        printf("Queue is empty\n");
        return;
    }
    printf("Queue elements: ");
    for (int i = queue->front; i != queue->rear; i = (i + 1) % MAX) {
        printf("%d ", queue->items[i]);
    }
    printf("%d\n", queue->items[queue->rear]);
}

// Function to get the front element of the queue
int peek(Queue* queue) {
    if (isEmpty(queue)) {
        printf("Queue is empty. No front element\n");
        return -1;
    }
    return queue->items[queue->front];
}

// Function to free the queue memory
void freeQueue(Queue* queue) {
    free(queue);
}

// Main function to demonstrate queue operations
int main() {
    Queue* myQueue = createQueue();

    // Enqueue elements
    for (int i = 1; i <= 10; i++) {
        enqueue(myQueue, i);
        displayQueue(myQueue);
    }

    // Dequeue elements
    for (int i = 0; i < 5; i++) {
        dequeue(myQueue);
        displayQueue(myQueue);
    }

    // Check front element
    int frontValue = peek(myQueue);
    if (frontValue != -1) {
        printf("Front element is: %d\n", frontValue);
    }

    // Cleanup
    freeQueue(myQueue);
    return 0;
}