//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: portable
/*
 * C Cafe Billing System
 *
 * A portable example program in C
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_NAME_LEN 32
#define MAX_PRODUCTS 10

// Define structure for a product
typedef struct {
    char name[MAX_NAME_LEN];
    float price;
} Product;

// Define structure for a customer
typedef struct {
    char name[MAX_NAME_LEN];
    int table_number;
    Product products[MAX_PRODUCTS];
    int num_products;
    float total_cost;
} Customer;

// Define structure for a bill
typedef struct {
    Customer customer;
    Product products[MAX_PRODUCTS];
    int num_products;
    float total_cost;
} Bill;

// Function to add a product to a customer's order
void add_product(Customer *customer, Product product) {
    if (customer->num_products < MAX_PRODUCTS) {
        customer->products[customer->num_products] = product;
        customer->num_products++;
    }
}

// Function to calculate the total cost of a customer's order
float calculate_total_cost(Customer *customer) {
    float total_cost = 0;
    for (int i = 0; i < customer->num_products; i++) {
        total_cost += customer->products[i].price;
    }
    return total_cost;
}

// Function to print a bill
void print_bill(Bill bill) {
    printf("Bill for %s\n", bill.customer.name);
    printf("Table number: %d\n", bill.customer.table_number);
    for (int i = 0; i < bill.num_products; i++) {
        printf("Product: %s\n", bill.products[i].name);
        printf("Price: $%.2f\n", bill.products[i].price);
    }
    printf("Total cost: $%.2f\n", bill.total_cost);
}

int main() {
    Customer customer = {
        "John Doe",
        12,
        {{ "Coffee", 2.50 }, { "Pastry", 3.50 }, { "Soda", 1.50 }},
        3,
        0
    };

    Bill bill = {
        customer,
        {{ "Coffee", 2.50 }, { "Pastry", 3.50 }, { "Soda", 1.50 }},
        3,
        0
    };

    add_product(&customer, (Product){ "Water", 1.00 });
    bill.total_cost = calculate_total_cost(&customer);

    print_bill(bill);

    return 0;
}