//GEMINI-pro DATASET v1.0 Category: Bucket Sort Implementation ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>

// Function to sort an array using bucket sort
void bucketSort(int arr[], int n) {
    // Create n empty buckets
    int buckets[n];
    for (int i = 0; i < n; i++) {
        buckets[i] = 0;
    }

    // Insert each element into its corresponding bucket
    for (int i = 0; i < n; i++) {
        buckets[arr[i]]++;
    }

    // Sort each bucket using insertion sort
    for (int i = 0; i < n; i++) {
        int sorted[n];
        int k = 0;
        for (int j = 0; j < n; j++) {
            if (buckets[i] > 0) {
                sorted[k++] = i;
                buckets[i]--;
            }
        }
        for (int j = 0; j < k; j++) {
            arr[j] = sorted[j];
        }
    }
}

// Function to print an array
void printArray(int arr[], int n) {
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Driver code
int main() {
    int arr[] = {5, 3, 1, 7, 4, 1, 2, 8, 6};
    int n = sizeof(arr) / sizeof(arr[0]);

    bucketSort(arr, n);

    printArray(arr, n);

    return 0;
}