//GPT-4o-mini DATASET v1.0 Category: Sorting ; Style: shape shifting
#include <stdio.h>

// Function to print the array
void printArray(int arr[], int size) {
    for (int i = 0; i < size; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Selection Sort
void selectionSort(int arr[], int size) {
    for (int i = 0; i < size - 1; i++) {
        int min_idx = i;
        for (int j = i + 1; j < size; j++) {
            if (arr[j] < arr[min_idx]) {
                min_idx = j;
            }
        }
        // Swap the found minimum element with the first element
        int temp = arr[min_idx];
        arr[min_idx] = arr[i];
        arr[i] = temp;

        // Print the array after each selection sort iteration
        printf("After selection step %d: ", i + 1);
        printArray(arr, size);
    }
}

// Bubble Sort
void bubbleSort(int arr[], int size) {
    for (int i = 0; i < size - 1; i++) {
        int swapped = 0;
        for (int j = 0; j < size - i - 1; j++) {
            if (arr[j] > arr[j + 1]) {
                // Swap if elements are not in order
                int temp = arr[j];
                arr[j] = arr[j + 1];
                arr[j + 1] = temp;
                swapped = 1;
            }
        }
        // If no elements were swapped, the array is already sorted
        if (swapped == 0) {
            break;
        }
        // Print the array after each bubble sort iteration
        printf("After bubble step %d: ", i + 1);
        printArray(arr, size);
    }
}

// Function to sort the array using shape shifting style
void shapeShiftingSort(int arr[], int size) {
    printf("Starting shape-shifting sort with initial array:\n");
    printArray(arr, size);

    // Alternate between selection sort and bubble sort
    for (int i = 0; i < size; i++) {
        if (i % 2 == 0) {
            printf("Executing Selection Sort step %d...\n", i / 2 + 1);
            selectionSort(arr, size);
        } else {
            printf("Executing Bubble Sort step %d...\n", (i + 1) / 2);
            bubbleSort(arr, size);
        }
        printf("Array state after step %d:\n", i + 1);
        printArray(arr, size);
    }

    printf("Final sorted array:\n");
    printArray(arr, size);
}

int main() {
    int arr[] = {64, 25, 12, 22, 11};
    int size = sizeof(arr)/sizeof(arr[0]);
    
    shapeShiftingSort(arr, size);

    return 0;
}