//MISTRAL-7B DATASET v1.0 Category: Networking ; Style: creative
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <time.h>

#define PORT 8080
#define MAX_BUFFER 1024
#define GARDEN_SIZE 10

struct Plant {
    char name[20];
    int health;
};

struct Plant garden[GARDEN_SIZE];

void init_garden() {
    int i;
    for (i = 0; i < GARDEN_SIZE; i++) {
        strcpy(garden[i].name, "Sunflower");
        garden[i].health = 100;
    }
}

void print_garden() {
    int i;
    for (i = 0; i < GARDEN_SIZE; i++) {
        printf("Plant %s: Health = %d\n", garden[i].name, garden[i].health);
    }
}

int main() {
    int server_fd, new_socket;
    struct sockaddr_in address;
    int addrlen = sizeof(address);
    char buffer[MAX_BUFFER] = {0};
    int client_fd[GARDEN_SIZE];
    int i;

    init_garden();

    if ((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    address.sin_family = AF_INET;
    address.sin_addr.s_addr = INADDR_ANY;
    address.sin_port = htons(PORT);

    if (bind(server_fd, (struct sockaddr *)&address, sizeof(address)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    if (listen(server_fd, GARDEN_SIZE) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    printf("Waiting for clients...\n");

    for (i = 0; i < GARDEN_SIZE; i++) {
        if ((client_fd[i] = accept(server_fd, (struct sockaddr *)&address,
                                  (socklen_t*)&addrlen)) < 0) {
            perror("accept");
            exit(EXIT_FAILURE);
        }

        printf("Client connected on socket [%d]\n", client_fd[i]);

        while (1) {
            int plant_index;
            recv(client_fd[i], buffer, MAX_BUFFER, 0);

            sscanf(buffer, "%s %d", garden[i].name, &garden[i].health);

            printf("Client [%d] changed Plant %s health to %d\n", i,
                   garden[i].name, garden[i].health);

            if (garden[i].health <= 0) {
                close(client_fd[i]);
                printf("Client [%d] disconnected\n", i);
                break;
            }

            sleep(rand() % 5 + 1); // Simulate plant growth
        }
    }

    close(server_fd);

    print_garden();

    return 0;
}