//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_CATEGORIES 10
#define MAX_SUPPLIERS 20

typedef struct {
    char name[30];
    int quantity;
    double price;
    char category[20];
    char supplier[20];
} Product;

typedef struct {
    char name[20];
    int num_products;
} Category;

typedef struct {
    char name[30];
    int num_products;
} Supplier;

Product products[MAX_PRODUCTS];
Category categories[MAX_CATEGORIES];
Supplier suppliers[MAX_SUPPLIERS];

int num_products = 0;
int num_categories = 0;
int num_suppliers = 0;

void add_product(Product* p) {
    products[num_products] = *p;
    num_products++;
}

void add_category(Category* c) {
    categories[num_categories] = *c;
    num_categories++;
}

void add_supplier(Supplier* s) {
    suppliers[num_suppliers] = *s;
    num_suppliers++;
}

void print_products() {
    printf("Product Name\tQuantity\tPrice\tCategory\tSupplier\n");
    for (int i = 0; i < num_products; i++) {
        printf("%s\t%d\t%.2f\t%s\t%s\n", products[i].name, products[i].quantity, products[i].price, products[i].category, products[i].supplier);
    }
}

void print_categories() {
    printf("Category Name\tNumber of Products\n");
    for (int i = 0; i < num_categories; i++) {
        printf("%s\t%d\n", categories[i].name, categories[i].num_products);
    }
}

void print_suppliers() {
    printf("Supplier Name\tNumber of Products\n");
    for (int i = 0; i < num_suppliers; i++) {
        printf("%s\t%d\n", suppliers[i].name, suppliers[i].num_products);
    }
}

int main() {
    Category c1 = {"Electronics", 5};
    add_category(&c1);

    Category c2 = {"Clothing", 3};
    add_category(&c2);

    Supplier s1 = {"Best Buy", 10};
    add_supplier(&s1);

    Supplier s2 = {"Walmart", 5};
    add_supplier(&s2);

    Product p1 = {"iPhone", 50, 999.99, "Electronics", "Best Buy"};
    add_product(&p1);

    Product p2 = {"Samsung TV", 30, 799.99, "Electronics", "Best Buy"};
    add_product(&p2);

    Product p3 = {"T-Shirt", 20, 19.99, "Clothing", "Walmart"};
    add_product(&p3);

    Product p4 = {"Jeans", 15, 49.99, "Clothing", "Walmart"};
    add_product(&p4);

    print_products();
    print_categories();
    print_suppliers();

    return 0;
}