//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: peaceful
#include <stdio.h>
#include <pcap/pcap.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

/* Callback function for capturing packets */
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Packet captured:\n");
    printf("Length: %d\n", header->len);
    printf("Data: ");
    for(int i=0; i<header->len; i++) {
        printf("%02X ", packet[i]);
    }
    printf("\n");
}

int main() {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    char filter_expression[100];
    struct bpf_program fp;

    /* Open the device for capturing */
    handle = pcap_create("eth0", errbuf);
    if(handle == NULL) {
        fprintf(stderr, "Error opening device: %s\n", errbuf);
        exit(1);
    }

    /* Compile the filter expression */
    strcpy(filter_expression, "tcp port 80");
    if(pcap_compile(handle, &fp, filter_expression, 0, 0) == -1) {
        fprintf(stderr, "Error compiling filter expression: %s\n", pcap_geterr(handle));
        exit(1);
    }

    /* Set the filter */
    if(pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    /* Start capturing packets */
    if(pcap_loop(handle, -1, packet_handler, NULL) == -1) {
        fprintf(stderr, "Error capturing packets: %s\n", pcap_geterr(handle));
        exit(1);
    }

    /* Close the device */
    pcap_freecode(&fp);
    pcap_close(handle);

    return 0;
}