//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>

// Process structure
typedef struct Process {
    int pid;        // Process ID
    int arrival;     // Arrival time
    int burst;      // Burst time
    int priority;   // Priority
    int remaining;  // Remaining burst time
} Process;

// Function to compare processes by arrival time
int compareArrival(const void *a, const void *b) {
    Process *p1 = (Process *)a;
    Process *p2 = (Process *)b;
    return p1->arrival - p2->arrival;
}

// Function to compare processes by priority
int comparePriority(const void *a, const void *b) {
    Process *p1 = (Process *)a;
    Process *p2 = (Process *)b;
    return p2->priority - p1->priority;
}

// Function to compare processes by remaining burst time
int compareRemaining(const void *a, const void *b) {
    Process *p1 = (Process *)a;
    Process *p2 = (Process *)b;
    return p1->remaining - p2->remaining;
}

// Function to find the waiting time for each process
void findWaitingTime(Process processes[], int n) {
    // Initialize waiting time for each process
    for (int i = 0; i < n; i++) {
        processes[i].remaining = processes[i].burst;
    }

    // Sort processes by arrival time
    qsort(processes, n, sizeof(Process), compareArrival);

    // Calculate waiting time for each process
    int current_time = processes[0].arrival;
    for (int i = 1; i < n; i++) {
        current_time = fmax(current_time, processes[i].arrival);
        processes[i].remaining -= current_time - processes[i - 1].arrival;
        current_time += processes[i].burst;
    }
}

// Function to find the turnaround time for each process
void findTurnaroundTime(Process processes[], int n) {
    // Calculate turnaround time for each process
    for (int i = 0; i < n; i++) {
        processes[i].remaining = processes[i].burst;
    }

    // Sort processes by arrival time
    qsort(processes, n, sizeof(Process), compareArrival);

    // Calculate turnaround time for each process
    int current_time = processes[0].arrival;
    for (int i = 1; i < n; i++) {
        current_time = fmax(current_time, processes[i].arrival);
        processes[i].remaining -= current_time - processes[i - 1].arrival;
        current_time += processes[i].burst;
        processes[i].remaining += current_time - processes[i].arrival;
    }
}

// Function to print the results
void printResults(Process processes[], int n) {
    // Print the results
    printf("Process ID\tArrival Time\tBurst Time\tPriority\tWaiting Time\tTurnaround Time\n");
    for (int i = 0; i < n; i++) {
        printf("%d\t\t%d\t\t%d\t\t%d\t\t%d\t\t%d\n", processes[i].pid, processes[i].arrival,
               processes[i].burst, processes[i].priority, processes[i].remaining, processes[i].remaining + processes[i].burst);
    }
}

// Main function
int main() {
    // Initialize processes
    Process processes[] = {
        {1, 0, 5, 1},
        {2, 2, 3, 2},
        {3, 4, 4, 3},
        {4, 8, 2, 4},
        {5, 12, 1, 5}
    };
    int n = sizeof(processes) / sizeof(processes[0]);

    // Sort processes by arrival time
    qsort(processes, n, sizeof(Process), compareArrival);

    // Find waiting time for each process
    findWaitingTime(processes, n);

    // Find turnaround time for each process
    findTurnaroundTime(processes, n);

    // Print the results
    printResults(processes, n);

    return 0;
}