//Falcon-180B DATASET v1.0 Category: Appointment Scheduler ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_EVENTS 100
#define MAX_EVENT_NAME_LEN 50

// Event structure
typedef struct {
    char name[MAX_EVENT_NAME_LEN];
    time_t start_time;
    time_t end_time;
} Event;

// Function to compare two events based on their start time
int compare_events(const void *a, const void *b) {
    const Event *event_a = (const Event *)a;
    const Event *event_b = (const Event *)b;

    if (event_a->start_time < event_b->start_time) {
        return -1;
    } else if (event_a->start_time > event_b->start_time) {
        return 1;
    } else {
        return 0;
    }
}

// Function to print the schedule
void print_schedule(Event events[], int num_events) {
    printf("Schedule:\n");
    printf("------------------------\n");
    for (int i = 0; i < num_events; i++) {
        printf("%s: %s - %s\n", events[i].name, ctime(&events[i].start_time), ctime(&events[i].end_time));
    }
}

int main() {
    Event events[MAX_EVENTS];
    int num_events = 0;

    // Add some sample events
    events[num_events++] = (Event){.name = "Meeting with Boss",.start_time = 1614575200,.end_time = 1614578800};
    events[num_events++] = (Event){.name = "Lunch with Colleagues",.start_time = 1614582400,.end_time = 1614586000};
    events[num_events++] = (Event){.name = "Doctor's Appointment",.start_time = 1614593600,.end_time = 1614597200};

    // Sort the events based on their start time
    qsort(events, num_events, sizeof(Event), compare_events);

    // Print the schedule
    print_schedule(events, num_events);

    return 0;
}