//Falcon-180B DATASET v1.0 Category: Searching algorithm ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>

// Function to perform linear search on an array
int linearSearch(int arr[], int n, int target) {
    for(int i=0; i<n; i++) {
        if(arr[i] == target) {
            return i;
        }
    }
    return -1;
}

// Function to perform binary search on a sorted array
int binarySearch(int arr[], int n, int target) {
    int left = 0, right = n-1;
    while(left <= right) {
        int mid = (left + right) / 2;
        if(arr[mid] == target) {
            return mid;
        } else if(arr[mid] < target) {
            left = mid + 1;
        } else {
            right = mid - 1;
        }
    }
    return -1;
}

int main() {
    int arr1[] = {1, 3, 5, 7, 9};
    int n1 = sizeof(arr1)/sizeof(arr1[0]);
    int target1 = 5;
    int result1 = linearSearch(arr1, n1, target1);
    if(result1 == -1) {
        printf("Element not found in array1\n");
    } else {
        printf("Element found at index %d in array1\n", result1);
    }

    int arr2[] = {2, 4, 6, 8, 10};
    int n2 = sizeof(arr2)/sizeof(arr2[0]);
    int target2 = 8;
    int result2 = binarySearch(arr2, n2, target2);
    if(result2 == -1) {
        printf("Element not found in array2\n");
    } else {
        printf("Element found at index %d in array2\n", result2);
    }

    return 0;
}