//GEMINI-pro DATASET v1.0 Category: Expense Tracker ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    char *description;
    double amount;
    struct tm *timestamp;
} Expense;

int main() {
    // Initialize an array of expenses
    Expense expenses[] = {
        { "Groceries", 100.00, localtime(NULL) },
        { "Rent", 1200.00, localtime(NULL) },
        { "Utilities", 150.00, localtime(NULL) },
        { "Transportation", 200.00, localtime(NULL) },
        { "Entertainment", 100.00, localtime(NULL) },
    };

    // Calculate the total expenses
    double total = 0.00;
    for (int i = 0; i < sizeof(expenses) / sizeof(Expense); i++) {
        total += expenses[i].amount;
    }

    // Calculate the average expenses
    double average = total / (double)sizeof(expenses) / sizeof(Expense);

    // Calculate the maximum expenses
    double max = 0.00;
    for (int i = 0; i < sizeof(expenses) / sizeof(Expense); i++) {
        if (expenses[i].amount > max) {
            max = expenses[i].amount;
        }
    }

    // Calculate the minimum expenses
    double min = max;
    for (int i = 0; i < sizeof(expenses) / sizeof(Expense); i++) {
        if (expenses[i].amount < min) {
            min = expenses[i].amount;
        }
    }

    // Print the expenses report
    printf("Total expenses: %.2f\n", total);
    printf("Average expenses: %.2f\n", average);
    printf("Maximum expenses: %.2f\n", max);
    printf("Minimum expenses: %.2f\n", min);

    return 0;
}