//Falcon2-11B DATASET v1.0 Category: Haunted House Simulator ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Structure for the room
struct Room {
    char name[20];
    char description[100];
    int num_monsters;
    int num_traps;
};

// Structure for the character
struct Character {
    char name[20];
    int health;
    int gold;
};

// Structure for the monster
struct Monster {
    char name[20];
    int health;
    int damage;
};

// Structure for the trap
struct Trap {
    char name[20];
    int damage;
};

void print_room_info(struct Room room) {
    printf("%s\n", room.name);
    printf("Number of monsters: %d\n", room.num_monsters);
    printf("Number of traps: %d\n", room.num_traps);
    printf("%s\n", room.description);
}

void print_character_info(struct Character character) {
    printf("%s\n", character.name);
    printf("Health: %d\n", character.health);
    printf("Gold: %d\n", character.gold);
}

void print_monster_info(struct Monster monster) {
    printf("%s\n", monster.name);
    printf("Health: %d\n", monster.health);
    printf("Damage: %d\n", monster.damage);
}

void print_trap_info(struct Trap trap) {
    printf("%s\n", trap.name);
    printf("Damage: %d\n", trap.damage);
}

void fight(struct Character character, struct Monster monster) {
    int damage = rand() % (monster.damage * 2) + 1;
    character.health -= damage;
    if (character.health <= 0) {
        printf("You died.\n");
    } else {
        printf("You dealt %d damage to the monster.\n", damage);
    }
}

int main() {
    // Create room structures
    struct Room room1 = {
        "Hallway",
        "You enter a dark and spooky hallway. You hear a strange noise coming from one of the rooms.",
        0,
        0
    };
    struct Room room2 = {
        "Kitchen",
        "You enter a kitchen full of spooky appliances. You hear a growling noise coming from the refrigerator.",
        0,
        0
    };
    struct Room room3 = {
        "Living Room",
        "You enter a living room full of spooky decorations. You hear a whispering noise coming from the fireplace.",
        0,
        0
    };
    struct Room room4 = {
        "Bedroom",
        "You enter a bedroom full of spooky dolls. You hear a giggling noise coming from one of the dolls.",
        0,
        0
    };

    // Create character structure
    struct Character character = {
        "Sam",
        100,
        0
    };

    // Create monster structure
    struct Monster monster = {
        "Zombie",
        100,
        10
    };

    // Create trap structure
    struct Trap trap = {
        "Trapdoor",
        20
    };

    // Print room info
    printf("Room 1:\n");
    print_room_info(room1);
    printf("\nRoom 2:\n");
    print_room_info(room2);
    printf("\nRoom 3:\n");
    print_room_info(room3);
    printf("\nRoom 4:\n");
    print_room_info(room4);

    // Print character info
    printf("Character:\n");
    print_character_info(character);

    // Print monster info
    printf("Monster:\n");
    print_monster_info(monster);

    // Print trap info
    printf("Trap:\n");
    print_trap_info(trap);

    // Fight the monster
    fight(character, monster);

    return 0;
}