//GPT-4o-mini DATASET v1.0 Category: Email Client ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#define SMTP_SERVER "smtp.example.com"
#define SMTP_USERNAME "your_email@example.com"
#define SMTP_PASSWORD "your_email_password"

void send_email(const char *to, const char *subject, const char *body) {
    CURL *curl;
    CURLcode res;
    struct curl_slist *recipients = NULL;
    
    curl = curl_easy_init();
    if (curl) {
        curl_easy_setopt(curl, CURLOPT_URL, SMTP_SERVER);
        curl_easy_setopt(curl, CURLOPT_USERNAME, SMTP_USERNAME);
        curl_easy_setopt(curl, CURLOPT_PASSWORD, SMTP_PASSWORD);
        
        // Set the email's From header
        curl_easy_setopt(curl, CURLOPT_MAIL_FROM, SMTP_USERNAME);
        
        // Add recipient
        recipients = curl_slist_append(recipients, to);
        curl_easy_setopt(curl, CURLOPT_MAIL_RCPT, recipients);
        
        // Set email subject and body
        char email_body[1024];
        snprintf(email_body, sizeof(email_body),
                 "To: %s\r\n"
                 "From: %s\r\n"
                 "Subject: %s\r\n"
                 "\r\n"
                 "%s\r\n", to, SMTP_USERNAME, subject, body);
        
        curl_easy_setopt(curl, CURLOPT_READFUNCTION, NULL);
        curl_easy_setopt(curl, CURLOPT_UPLOAD, 1L);
        curl_easy_setopt(curl, CURLOPT_READDATA, email_body);
        
        // Enable verbose output for debugging
        curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L);
        
        // Perform the email sending
        res = curl_easy_perform(curl);
        
        if (res != CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        }
        
        // Clean up
        curl_slist_free_all(recipients);
        curl_easy_cleanup(curl);
    }
}

int main(int argc, char *argv[]) {
    if (argc < 4) {
        fprintf(stderr, "Usage: %s <to_email> <subject> <body>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *to_email = argv[1];
    const char *subject = argv[2];
    const char *body = argv[3];

    // Send email
    send_email(to_email, subject, body);
    
    printf("Email sent to %s with subject: %s\n", to_email, subject);
    
    return EXIT_SUCCESS;
}