//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LENGTH 50
#define MAX_DESCRIPTION_LENGTH 100

typedef struct {
    char name[MAX_NAME_LENGTH];
    char description[MAX_DESCRIPTION_LENGTH];
    int quantity;
    double price;
} Product;

int num_products = 0;
Product products[MAX_PRODUCTS];

void add_product(Product *product) {
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Too many products.\n");
        return;
    }
    strcpy(products[num_products].name, product->name);
    strcpy(products[num_products].description, product->description);
    products[num_products].quantity = product->quantity;
    products[num_products].price = product->price;
    num_products++;
}

void display_products() {
    printf("Product Inventory:\n");
    printf("--------------------\n");
    for (int i = 0; i < num_products; i++) {
        printf("%d. Name: %s\n", i+1, products[i].name);
        printf("Description: %s\n", products[i].description);
        printf("Quantity: %d\n", products[i].quantity);
        printf("Price: $%.2f\n\n", products[i].price);
    }
}

void search_product(char *name) {
    int found = 0;
    for (int i = 0; i < num_products; i++) {
        if (strcmp(products[i].name, name) == 0) {
            printf("Product found:\n");
            printf("Name: %s\n", products[i].name);
            printf("Description: %s\n", products[i].description);
            printf("Quantity: %d\n", products[i].quantity);
            printf("Price: $%.2f\n", products[i].price);
            found = 1;
            break;
        }
    }
    if (!found) {
        printf("Product not found.\n");
    }
}

int main() {
    Product product1 = {"Apple", "Red and juicy", 100, 0.50};
    add_product(&product1);

    Product product2 = {"Banana", "Yellow and sweet", 50, 0.25};
    add_product(&product2);

    display_products();

    search_product("Banana");

    return 0;
}