//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the structure of a point in 2D space
typedef struct {
    double x;
    double y;
} Point;

// Define the structure of a line segment in 2D space
typedef struct {
    Point p1;
    Point p2;
} LineSegment;

// Define the structure of a circle in 2D space
typedef struct {
    Point center;
    double radius;
} Circle;

// Function to calculate the distance between two points
double distance(Point p1, Point p2) {
    return sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
}

// Function to check if two line segments intersect
int doIntersect(LineSegment ls1, LineSegment ls2) {
    // Check if the two line segments are parallel
    if ((ls1.p1.x - ls1.p2.x) * (ls2.p1.y - ls2.p2.y) - (ls1.p1.y - ls1.p2.y) * (ls2.p1.x - ls2.p2.x) == 0) {
        return 0;
    }

    // Check if the two line segments intersect
    double t1 = ((ls2.p1.x - ls2.p2.x) * (ls1.p1.y - ls2.p1.y) - (ls2.p1.y - ls2.p2.y) * (ls1.p1.x - ls2.p1.x)) / ((ls1.p1.x - ls1.p2.x) * (ls2.p1.y - ls2.p2.y) - (ls1.p1.y - ls1.p2.y) * (ls2.p1.x - ls2.p2.x));
    double t2 = ((ls1.p1.x - ls1.p2.x) * (ls1.p1.y - ls2.p1.y) - (ls1.p1.y - ls1.p2.y) * (ls1.p1.x - ls2.p1.x)) / ((ls1.p1.x - ls1.p2.x) * (ls2.p1.y - ls2.p2.y) - (ls1.p1.y - ls1.p2.y) * (ls2.p1.x - ls2.p2.x));

    if (t1 >= 0 && t1 <= 1 && t2 >= 0 && t2 <= 1) {
        return 1;
    }

    return 0;
}

// Function to check if a point is inside a circle
int isInsideCircle(Point p, Circle c) {
    return distance(p, c.center) <= c.radius;
}

int main() {
    // Define two line segments
    LineSegment ls1 = {{0, 0}, {1, 1}};
    LineSegment ls2 = {{0, 1}, {1, 0}};

    // Check if the two line segments intersect
    if (doIntersect(ls1, ls2)) {
        printf("The two line segments intersect.\n");
    } else {
        printf("The two line segments do not intersect.\n");
    }

    // Define a point
    Point p = {0.5, 0.5};

    // Define a circle
    Circle c = {{0, 0}, 1};

    // Check if the point is inside the circle
    if (isInsideCircle(p, c)) {
        printf("The point is inside the circle.\n");
    } else {
        printf("The point is outside the circle.\n");
    }

    return 0;
}