//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Structure to store fitness data
typedef struct {
  int steps;
  int calories;
  int distance;
  int heart_rate;
} fitness_data;

// Function to initialize fitness data
void initialize_fitness_data(fitness_data *data) {
  data->steps = 0;
  data->calories = 0;
  data->distance = 0;
  data->heart_rate = 0;
}

// Function to track steps
void track_steps(fitness_data *data, int steps) {
  data->steps += steps;
}

// Function to track calories
void track_calories(fitness_data *data, int calories) {
  data->calories += calories;
}

// Function to track distance
void track_distance(fitness_data *data, int distance) {
  data->distance += distance;
}

// Function to track heart rate
void track_heart_rate(fitness_data *data, int heart_rate) {
  data->heart_rate = heart_rate;
}

// Function to print fitness data
void print_fitness_data(const fitness_data *data) {
  printf("Steps: %d\n", data->steps);
  printf("Calories: %d\n", data->calories);
  printf("Distance: %d\n", data->distance);
  printf("Heart Rate: %d\n", data->heart_rate);
}

// Main function
int main() {
  // Initialize fitness data
  fitness_data data;
  initialize_fitness_data(&data);

  // Track some fitness data
  track_steps(&data, 10000);
  track_calories(&data, 500);
  track_distance(&data, 5);
  track_heart_rate(&data, 70);

  // Print fitness data
  print_fitness_data(&data);

  return 0;
}