//Falcon-180B DATASET v1.0 Category: Phone Book ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum length of a name and phone number
#define MAX_NAME_LENGTH 50
#define MAX_PHONE_LENGTH 20

// Define the structure for a phone book entry
typedef struct {
    char name[MAX_NAME_LENGTH];
    char phone[MAX_PHONE_LENGTH];
} PhoneBookEntry;

// Define the function for comparing two phone book entries
int compareEntries(const void *a, const void *b) {
    const PhoneBookEntry *entryA = (const PhoneBookEntry *)a;
    const PhoneBookEntry *entryB = (const PhoneBookEntry *)b;

    // Compare the names
    int result = strcmp(entryA->name, entryB->name);
    if (result!= 0) {
        return result;
    }

    // If the names are equal, compare the phone numbers
    return strcmp(entryA->phone, entryB->phone);
}

// Define the function for printing a phone book entry
void printEntry(const PhoneBookEntry *entry) {
    printf("%s: %s\n", entry->name, entry->phone);
}

// Define the main function for the phone book program
int main() {
    // Initialize the phone book with some entries
    PhoneBookEntry entries[] = {
        {"Alice", "555-1234"},
        {"Bob", "555-5678"},
        {"Charlie", "555-9012"},
        {"David", "555-3456"},
        {"Eve", "555-7890"}
    };

    // Sort the phone book entries
    qsort(entries, sizeof(entries) / sizeof(entries[0]), sizeof(entries[0]), compareEntries);

    // Print the sorted phone book
    printf("Sorted phone book:\n");
    for (int i = 0; i < sizeof(entries) / sizeof(entries[0]); i++) {
        printEntry(&entries[i]);
    }

    return 0;
}