//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ACCOUNTS 100
#define MAX_TRANSACTIONS 1000

typedef struct {
    int accountNumber;
    char name[50];
    double balance;
} Account;

typedef struct {
    int accountNumberFrom;
    int accountNumberTo;
    double amount;
    char description[100];
} Transaction;

Account accounts[MAX_ACCOUNTS];
Transaction transactions[MAX_TRANSACTIONS];

int numAccounts = 0;
int numTransactions = 0;

void createAccount(int accountNumber, char* name, double balance) {
    accounts[numAccounts].accountNumber = accountNumber;
    strcpy(accounts[numAccounts].name, name);
    accounts[numAccounts].balance = balance;
    numAccounts++;
}

void deposit(int accountNumber, double amount) {
    for (int i = 0; i < numAccounts; i++) {
        if (accounts[i].accountNumber == accountNumber) {
            accounts[i].balance += amount;
            break;
        }
    }
}

void withdraw(int accountNumber, double amount) {
    for (int i = 0; i < numAccounts; i++) {
        if (accounts[i].accountNumber == accountNumber) {
            if (accounts[i].balance >= amount) {
                accounts[i].balance -= amount;
            } else {
                printf("Insufficient funds\n");
            }
            break;
        }
    }
}

void transfer(int accountNumberFrom, int accountNumberTo, double amount, char* description) {
    for (int i = 0; i < numAccounts; i++) {
        if (accounts[i].accountNumber == accountNumberFrom) {
            for (int j = 0; j < numAccounts; j++) {
                if (accounts[j].accountNumber == accountNumberTo) {
                    if (accounts[i].balance >= amount) {
                        accounts[i].balance -= amount;
                        accounts[j].balance += amount;
                        strcpy(transactions[numTransactions].description, description);
                        transactions[numTransactions].accountNumberFrom = accountNumberFrom;
                        transactions[numTransactions].accountNumberTo = accountNumberTo;
                        transactions[numTransactions].amount = amount;
                        numTransactions++;
                    } else {
                        printf("Insufficient funds\n");
                    }
                    break;
                }
            }
            break;
        }
    }
}

void displayAccounts() {
    printf("Account Number\tName\tBalance\n");
    for (int i = 0; i < numAccounts; i++) {
        printf("%d\t%s\t%.2f\n", accounts[i].accountNumber, accounts[i].name, accounts[i].balance);
    }
}

void displayTransactions() {
    printf("Transaction Number\tFrom Account\tTo Account\tAmount\tDescription\n");
    for (int i = 0; i < numTransactions; i++) {
        printf("%d\t%d\t%d\t%.2f\t%s\n", i+1, transactions[i].accountNumberFrom, transactions[i].accountNumberTo, transactions[i].amount, transactions[i].description);
    }
}

int main() {
    createAccount(12345, "John Doe", 1000);
    createAccount(67890, "Jane Smith", 500);
    deposit(12345, 200);
    withdraw(67890, 50);
    transfer(12345, 67890, 250, "Payment for goods");
    displayAccounts();
    displayTransactions();
    return 0;
}